package mole 
{
	import net.flashpunk.FP;
	import net.flashpunk.Sfx;
	import net.flashpunk.tweens.sound.SfxFader;
	
	/**
	 * Gestionnaire de son et musique.
	 * @author Cédric Liaudet
	 */
	public class CSoundManager
	{
		/**
		 * Constructeur.
		 */
		public function CSoundManager() 
		{
			m_CurrentMusic = null;
			m_MusicFader = null;
			m_FadeOutCallback = null;
		}
		
		/**
		 * 
		 * @param	_Source
		 */
		public function PlayRandomSound(_Source:Array):void
		{
			var sound:Sfx = new Sfx(FP.choose(_Source));
			sound.play();
		}
		
		/**
		 * 
		 * @param	_Source
		 * @param	_bFade
		 * @param	_Duration
		 * @param	_Complete
		 */
		public function PlayMusic(_Source:Class, _bFade:Boolean = true, _Duration:Number = 15):void
		{
			// creation du nouveau son.
			var newMusic:Sfx = new Sfx(_Source);
				
			// On fait un fade.
			if (_bFade)
			{				
				newMusic.loop(0, 0);
					
				// cross fade si il y a une musique courante.
				if(m_CurrentMusic)
				{
					m_MusicFader = new SfxFader(m_CurrentMusic, this.OnCrossFadeComplete, 0);					
					m_MusicFader.crossFade(newMusic, true, _Duration, 1, null);
				}
				else
				{								
					// creation du fade.
					m_MusicFader = new SfxFader(newMusic, this.OnFadeInComplete, 0);
					m_MusicFader.fadeTo(1, _Duration);					
				}
				
				m_MusicFader.start();
			}
			else
			{
				if (m_CurrentMusic)
					m_CurrentMusic.stop();
					
				newMusic.play(1, 0);
			}
			
			// Definie la nouvelle musique comme la courante.
			m_CurrentMusic = newMusic;
		}
		
		/**
		 * Stop la musique en cours.
		 * @param	_bFade
		 * @param	_Duration
		 * @param	_Complete
		 */
		public function StopMusic(_bFade:Boolean = true, _Duration:Number = 15, _Complete:Function = null):void
		{
			if (m_CurrentMusic)
			{
				if (_bFade)
				{
					m_FadeOutCallback = _Complete;
					
					// creation du fade.
					m_MusicFader = new SfxFader(m_CurrentMusic, this.OnFadeOutComplete, 0);
					m_MusicFader.fadeTo(0, _Duration);
				}
				else
				{
					m_CurrentMusic.stop();
					m_CurrentMusic = null;
				}
			}
		}
		
		/**
		 * Callback quand le cross fade se termine.
		 */
		public function OnCrossFadeComplete():void
		{
			m_MusicFader = null;			
		}
		
		/**
		 * Callback quand le fade int se termine.
		 */
		public function OnFadeInComplete():void
		{
			m_MusicFader = null;
		}
		
		/**
		 * Callback quand le fade out se termine.
		 */
		public function OnFadeOutComplete():void
		{			
			m_MusicFader = null;
			m_CurrentMusic = null;
			
			if (m_FadeOutCallback != null)
			{				
				m_FadeOutCallback();
				m_FadeOutCallback = null;
			}			
		}
		
		/**
		 * Mise à jours du moteur son.
		 */
		public function OnUpdate():void
		{
			if (m_MusicFader)
				m_MusicFader.update();
		}
		
		private var m_CurrentMusic:Sfx; 		///< Musique courante.
		private var m_MusicFader:SfxFader;		///< Permet de faire un fade sur la musique.
		private var m_FadeOutCallback:Function;	///< Callback lorsque le fade out est fini.
	}

}